function [last_episodes, av_all_episodes]=simulation_rep(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,K)

%This function returns, for the two-period, 2 AMMs case:

%last_episodes, a Kx22 matrix containing for each experiment k, in columns:

%1: Price actually played by AMM 1 in episode T, tau = 1
%2: Price actually played by AMM 1 in episode T, tau = 2
%3: Price actually played by AMM 2 in episode T, tau = 1
%4: Price actually played by AMM 2 in episode T, tau = 2
%5: Greedy price of AMM1 in episode T, tau = 1
%6: Greedy price of AMM1 in episode T, tau = 2, s_1 = NT
%7: Greedy price of AMM1 in episode T, tau = 2, s_1 = 0
%8: Greedy price of AMM1 in episode T, tau = 2, s_1 = 1/2
%9: Greedy price of AMM1 in episode T, tau = 2, s_1 = 1
%10: Greedy price of AMM2 in episode T, tau = 1
%11: Greedy price of AMM2 in episode T, tau = 2, s_2 = NT
%12: Greedy price of AMM2 in episode T, tau = 2, s_2 = 0
%13: Greedy price of AMM2 in episode T, tau = 2, s_2 = 1/2
%14: Greedy price of AMM2 in episode T, tau = 2, s_2 = 1
%15: Equal to 1 if s_1 = NT, 0 otherwise
%16: Equal to 1 if s_1 = 0, 0 otherwise
%17: Equal to 1 if s_1 = 1/2, 0 otherwise
%18: Equal to 1 if s_1 = 1, 0 otherwise
%19: v_tilde
%20: l_tilde_1
%21: l_tilde_2
%22: C_t

%av_all_episodes: A Tx40 matrix containing for each episode t the mean
%across K experiments of the following variables, in columns:

%1: Price actually played by AMM 1 in episode T, tau = 1
%2: Price actually played by AMM 1 in episode T, tau = 2
%3: Price actually played by AMM 2 in episode T, tau = 1
%4: Price actually played by AMM 2 in episode T, tau = 2
%5: Greedy price of AMM1 in episode T, tau = 1
%6: Greedy price of AMM1 in episode T, tau = 2, s_1 = NT
%7: Greedy price of AMM1 in episode T, tau = 2, s_1 = 0
%8: Greedy price of AMM1 in episode T, tau = 2, s_1 = 1/2
%9: Greedy price of AMM1 in episode T, tau = 2, s_1 = 1
%10: Greedy price of AMM2 in episode T, tau = 1
%11: Greedy price of AMM2 in episode T, tau = 2, s_2 = NT
%12: Greedy price of AMM2 in episode T, tau = 2, s_2 = 0
%13: Greedy price of AMM2 in episode T, tau = 2, s_2 = 1/2
%14: Greedy price of AMM2 in episode T, tau = 2, s_2 = 1
%15: Equal to 1 if s_1 = NT, 0 otherwise
%16: Equal to 1 if s_1 = 0, 0 otherwise
%17: Equal to 1 if s_1 = 1/2, 0 otherwise
%18: Equal to 1 if s_1 = 1, 0 otherwise
%19: a_min1 (ask price in tau = 1)
%20: a_min2 (ask price in tau = 2)

%Columns 21 to 40 contain the averages of the squared values of the
%variables in columns 1 to 20, in the same order.

%Initialize
last_episodes = zeros(K,22);
av_all_episodes = zeros(T,40);

%Run K experiments.
%Replace "parfor" with "for" to run without parallelization.

parfor k=1:K
    %Calls the function simulation_exp
    [last_episode,all_episodes] = simulation_exp(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size);
    %Records the last episode
    last_episodes(k,:) = last_episode;
    %Adds the values of all episodes to the existing av_all_episodes
    av_all_episodes = av_all_episodes + all_episodes;
    %Uncomment the next line to follow the execution of the code
    %disp(k)
end

%Divide av_all_episodes by K to get the average across all experiments:
av_all_episodes = av_all_episodes/K;
